define([
    'jquery',
    'underscore',
    'backbone',
    'Layout',
    'modules/appointments/messages/request-message-view',
    'modules/notification-preferences/notification-preferences-module',
    'modules/appointments/appointments-radio',
    'modules/appointments/messages/request-message',
    'modules/new-appointment-request/tests/helpers/general-helper',
], function($, _, Backbone, Layout, View, notificationModule, radio, MessageModel, helpers) {
    'use strict';

    describe('Request Message View', function() {
        var view;
        var layout = new Layout();

        layout.render();
        beforeEach(function () {
            view = new View(new Backbone.Model({
                service: 'service',
                travelBurden: true,
                unusualTravelBurden: false,
                typeOfCareId: 'CCUD',
                facility: 'Boston',
                zipCode: '02033',
                distanceWillingToTravel: '10',
                optionDate1: '11/08/2014',
                optionTime1: 'AM',
                optionDate2: 'No Date Selected',
                optionTime2: 'No Time Selected',
                optionDate3: 'No Date Selected',
                optionTime3: 'No Time Selected',
                phoneNumber: '703-234-5670',
                bestTimetoCall: [
                    'Afternoon',
                    'Evening',
                ],
                requestedPhoneCall: true,
                providerOption: 'Call before booking appointment',
                visitType: 'Office Visit',
                appointmentType: 'Audiology',
                reasonForVisit: 'Placeholder until the form has a reason for visit!',
                email: 'joe@joe.com',
                purposeOfVisit: 'routine-follow-up',
                providerId: '0',
                patientIdentifier: {
                    uniqueId: '1',
                    assigningAuthority: 'xxx',
                },
            }));

            layout.showChildView('fDNS   tent', view);
        });
        describe('navigateToRequestDetails', function() {
            it('calls the correct redirect radio request', function() {
                var isCalled = false;
                var model = new Backbone.Model({clinic: {}});
                radio.once('appointments:request:selected', function(details, options) {
                    isCalled = true;
                    expect(details).toBe(model);
                    expect(options.showFeedbackLink).toBeTruthy();
                    expect(options.showCancellation).toBeFalsy();
                });

                view.navigateToRequestDetails(model);
                expect(isCalled).toBe(true);
            });
        });
        describe('checkForMessage', function() {
            var model;

            beforeEach(function() {
                spyOn(view, 'saveRequestMessage').and.callFake(_.noop);
                spyOn(view, 'navigateToRequestDetails').and.callFake(_.noop);
                model = new Backbone.Model({link: [{rel: 'self'}]});
            });

            it('saves the custom message before redirect', function() {
                model.set('newMessage', 'test', {silent: true});
                view.checkForMessage(model);

                expect(view.saveRequestMessage).toHaveBeenCalled();
            });

            it('goes right to details when there is no new message', function() {
                view.checkForMessage(model);

                expect(view.navigateToRequestDetails).toHaveBeenCalled();
            });
        });
        describe('saveRequestMessage', function() {
            var message;
            var request;
            var userId;

            beforeEach(function() {
                spyOn(MessageModel.prototype, 'saveMessage').and.callFake(function(_message, _request, _userId) {
                    message = _message;
                    request = _request;
                    userId = _userId;
                });
            });

            it('calls the message Model save function with the correct params', function() {
                var m = 'This is a test of the emergency blah blah blah';
                var r = new Backbone.Model();
                var u = view.requestModel.get('patientIdentifier').uniqueId;
                view.saveRequestMessage(m, r);

                expect(message).toBe(m);
                expect(request).toBe(r);
                expect(userId).toBe(u);
            });
        });
    });
});
